unit u_timedisplay;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Graphics, u_scope;

var
  Trace0, Trace1, Trace2, Trace3, Trace4, Trace5,
  Trace6, Trace7, Trace8, Trace9, Trace10, Trace11: Ttrace;
  nPoints: integer;

procedure TimeDisplay_Init;
procedure TimeDisplay_Refresh;
procedure TimeDisplay_Update_TCenterDiff_Mag;
procedure TimeDisplay_Update_TCenterDiff_Cap;
procedure TimeDisplay_Update_TRim1Diff_Mag;
procedure TimeDisplay_Update_ARim1Diff_Mag;
procedure TimeDisplay_Update_Fast;
procedure TimeDisplay_Update_Slow;

implementation

uses u_main, u_messages, u_calc, u_timestrings;

procedure TimeDisplay_Init;
// effective display area is 500 x 320 pixels
// Y goes from -160 to +160 around centerline = zero
// Scale is 50 pixels / div horizontal and 45 px / div vertical
begin
  TimeDisplay.Init
    (FrmMain,
     TimeDisplay_Left, TimeDisplay_Top,
     TimeDisplay_Num_Xdivs, TimeDisplay_Num_Ydivs,
     TimeDisplay_Num_XpixPerDiv, TimeDisplay_Num_YpixPerDiv,
     TimeDisplay_GridColor);
  TimeDisplay.WriteText (2, 2, DateTimeStamp);

  // Initialize Trace arrays
  nPoints:= TimeDisplay.sc_width;
  Setlength (Trace0, nPoints + 1);
  Setlength (Trace1, nPoints + 1);
  Setlength (Trace2, nPoints + 1);
  Setlength (Trace3, nPoints + 1);
  Setlength (Trace4, nPoints + 1);
  Setlength (Trace5, nPoints + 1);
  Setlength (Trace6, nPoints + 1);
  Setlength (Trace7, nPoints + 1);
  Setlength (Trace8, nPoints + 1);
  Setlength (Trace9, nPoints + 1);
  Setlength (Trace10, nPoints + 1);
  Setlength (Trace11, nPoints + 1);
  TimeDisplayIsInitialized:= true;
end;

procedure TimeDisplay_Refresh; // show the selected traces
begin
  TimeDisplay_Init;
  with FrmMain do with TimeDisplay do
  begin
  // Slow display
  if CbxShowHours.Checked              then PlotTrace (Trace0, clWhite);   // 0 Hours
  if CbxShowPrecessionAngle.Checked    then PlotTrace (Trace1, clLime);    // 1 Precession angle
  if CbxShowMinorAxis.Checked          then PlotTrace (Trace2, clFuchsia); // 2 Minor axis
  if CbxShowMajorAxis.Checked          then PlotTrace (Trace3, clFuchsia); // 3 Major axis

  // Fast display
  if RBMemoShowTDiffCenter_Mag.Checked then PlotTrace (Trace4, clYellow);  // 4 TDiffCenter_Mag
  if RBMemoShowTDiffCenter_Cap.Checked then PlotTrace (Trace5, clYellow);  // 5 TDiffCenter_Cap
  if RBMemoShowTDiffRim1_Mag.Checked   then PlotTrace (Trace6, clYellow);  // 6 TDiffRim1_Mag
  if RBMemoShowADiffRim1_Mag.Checked   then PlotTrace (Trace7, clYellow);  // 7 ADiffRim1_Mag
  if CbxShowAC_Mag.Checked             then PlotTrace (Trace8, clAqua);    // 8 APC_Mag
  if CbxShowAC_Cap.Checked             then PlotTrace (Trace9, clRed);     // 9 APC_Cap
  if CbxShowCenterWidth_Cap.Checked    then PlotTrace (Trace10, clWhite);  // 10 Center Width_Cap
  if CbxShowDriveStrength.Checked      then PlotTrace (Trace11, clWhite);  // 11 DriveStrength
  end;
end;

procedure TimeDisplay_Update_TCenterDiff_Mag;
// Updated each HalfSwing on CenterPass_Mag
var i: integer;
begin
  for i:= 2 to nPoints - 1 do // shift trace 1 pixel left
    Trace4[i]:= Trace4[i + 1];
  Trace4[nPoints]:= TPassCenterDiff_Mag;   // scale below mid of graph
end;

procedure TimeDisplay_Update_TCenterDiff_Cap;
// Updated each HalfSwing on CenterPass_Cap
var i: integer;
begin
  for i:= 2 to nPoints - 1 do // shift trace 1 pixel left
    Trace5[i]:= Trace5[i + 1];
  Trace5[nPoints]:= TPassCenterDiff_Cap div 4; // scale on mid of graph
end;

procedure TimeDisplay_Update_TRim1Diff_Mag;
// Updated each HalfSwing on Rim1 Pass Event
var i: integer;
begin
  for i:= 2 to nPoints - 1 do // shift trace 1 pixel left
    Trace6[i]:= Trace6[i + 1];
  Trace6[nPoints]:= TDiffRim1_Mag; // scale on mid of graph
end;

procedure TimeDisplay_Update_ARim1Diff_Mag;
// Updated each HalfSwing on Rim1 Pass Event
var i: integer;
begin
  for i:= 2 to nPoints - 1 do // shift trace 1 pixel left
    Trace7[i]:= Trace7[i + 1];
  Trace7[nPoints]:= ADiffRim1_Mag; // scale on mid of graph
end;

procedure TimeDisplay_Update_Fast;
// Updated each HalfSwing
var i: integer;
begin
  for i:= 2 to nPoints - 1 do // shift traces 1 pixel left
  begin
    Trace8[i]:= Trace8[i + 1];
    Trace9[i]:= Trace9[i + 1];
    Trace10[i]:= Trace10[i + 1];
    Trace11[i]:= Trace11[i + 1];
  end;
  Trace8[nPoints]:= APeakCenter_Mag div 4 - 160;          // scale from bottom of graph
  Trace9[nPoints]:= APeakCenter_Cap div 4 - 160;          // scale from bottom of graph
  Trace10[nPoints]:= round (WidthCenter_Cap / 10) - 160;  // scale from bottom of graph
  if UseMinimalDriveCurrent then Trace11[nPoints]:= -150; // scale near bottom of graph
  if UseMaximalDriveCurrent then Trace11[nPoints]:= -140; // scale near bottom of graph
  TimeDisplay_Refresh;
end;

procedure TimeDisplay_Update_Slow;
// Updated for 10, 60 or 300 seconds per division
var i: integer;
begin
  for i:= 2 to nPoints - 1 do // shift traces 1 pixel left
  begin
    Trace0[i]:=  Trace0[i + 1]; // Hours
    Trace1[i]:=  Trace1[i + 1]; // FP angle
    Trace2[i]:=  Trace2[i + 1]; // Minor axis
    Trace3[i]:=  Trace3[i + 1]; // Major axis
  end;
  Trace0[nPoints]:=  round (HourOfDay * 40 / 3 - 160);            // scale for 3 hr/div from bottom of graph
  Trace1[nPoints]:=  round (PrecessionAngle_Degrees * 160 / 180); // scale for 45 degrees per div
  Trace2[nPoints]:=  round (EllipseMinorAxis_mm);                 // scale for .. mm / div
  Trace3[nPoints]:=  round (EllipseMajorAxis_mm - 160);           // scale from bottom for .. mm / div
  TimeDisplay_Refresh;
end;

begin
// no unit initialisation code
end.

