unit u_numstrings;

// Purpose: Some Numerical conversions

{$mode objfpc}{$H+}

interface

uses SysUtils;

function FIval (InpStr: shortstring): longint;
function FRval (InpStr: shortstring): real;
function BytesView (InpStr: shortstring; Nch: integer): shortstring;
function BytesViewHex (InpStr: shortstring; Nch: integer): shortstring;

implementation

function FIval (InpStr: shortstring): longint;
var Temp: longint;
begin
  val (InpStr, Temp);
  FIval:= Temp;
end;

function FRval (InpStr: shortstring): real;
var Temp: real;
begin
  val (InpStr, Temp);
  FRval:= Temp;
end;

function BytesView (InpStr: shortstring; Nch: integer): shortstring;
var N, A: integer; Temp, Total: shortstring;
begin
  Total:= '';
  for N:= 1 to Nch do
  begin
    A:= byte (InpStr[N]);
    str(A:3, Temp);
    if Temp[2]= ' ' then Temp[2]:= '0';
    if Temp[1]= ' ' then Temp[1]:= '0';
    Total:= Total + Temp + ': ';
  end;
  BytesView:= Total;
end;

function BytesViewHex (InpStr: shortstring; Nch: integer): shortstring;
var N, A: integer; Temp, Total: shortstring;
begin
  Total:= '';
  for N:= 1 to Nch do
  begin
    A:= byte (InpStr[N]);
    Temp:= format ('%2x',[A]);
    if Temp[1]= ' ' then Temp[1]:= '0';
    Total:= Total + Temp + ':';
  end;
  BytesViewhex:= Total;
end;

begin
// no unit initialisation code
end.

