/////////////////////////////////////////////////////////////////////////////////////////
// Module Name: Globals.h
// Project: Foucault Pendulum, Subsystem BobControl
// Target CPU: Arduino MEGA + ETHernet Shield
// Target hardware: BobControl_v1
// Last Modification: See below
// Author: Jan Breemer, jan@breem.nl
// www.foucaultpendulum.nl
/////////////////////////////////////////////////////////////////////////////////////////

#ifndef GLOBALS_H
#define GLOBALS_H

#include <Arduino.h>
#include <Wire.h> // for I2C interface BME280

// General
extern unsigned long Command, Status;
extern unsigned int FirmwareVersionNumber;
extern char PrintStr[100]; // for diagnostic messages
extern bool 
  Opt1, Opt2, Opt3, Opt4,
  DoReportParameters, GeneralError;
void ResetArduino (void);
void ReadOptionJumpers (void);

// For Communication
extern bool HaveComm;
void Init_Messages (void);
void Update_Messages (void);

// For EEPROM Storage
#define EEPROM_STARTADDRESS_PARAMETERS 100
extern bool DoWriteParametersToEEprom;

// For Climate measurement etc.
extern bool BME280_IsInitialized, DoReadBME; 
extern int BME_Temperature, BME_Hygro, BME_Baro;
  
// for Position Measurement System
extern unsigned int
  Adc_North, Adc_South, Adc_East, Adc_West,  
  Center_North, Center_South, Center_East, Center_West;
   
// for Center Detection Magnetic:
extern unsigned int
  PositionCounter_Mag,
  TStartLookForCenter_Mag, TMissedCenter_Mag,
  TPassCenter_Mag, Adc_Center_Mag, APeakCenter_Mag, AMidCenter_Mag;
extern bool
  SeenCenter_Mag, MissedCenter_Mag, OverRangeCenter_Mag;

// for Center Detection Capacitive 
extern unsigned int
  PositionCounter_Cap,
  TStartLookForCenter_Cap, TMissedCenter_Cap,
  TPassCenter_Cap, WidthCenter_Cap,
  Adc_Center_Cap, APeakCenter_Cap, ABaseCenter_Cap, AHalfHeightCenter_Cap,
  Adc_Rim_Cap;
extern bool
  EnableDetectorCenterPass_Cap, Seencenter_Cap, MissedCenter_Cap, OverRangeCenter_Cap;

// for Wire touching a Charron Ring:
#define TOUCH_CHARRON (PING & 0x04) == 0x00
extern bool Touch_Charron;

// for Rim Detection Magnetic:
extern unsigned int
  PositionCounter_Rim,
  TStartLookForRim1_Mag, TMissedRim1_Mag,
  TStartLookForRim2_Mag, TMissedRim2_Mag,
  TPassRim1_Mag, TPassRim2_Mag,
  Adc_Rim_Mag, AMidRim_Mag, APeakRim1_Mag, APeakRim2_Mag;
extern bool
  EnableDetectorCenterPass_Mag, 
  EnableDetectorCenterPass_Mag,
  SeenRim1_Mag, MissedRim1_Mag,
  SeenRim2_Mag, MissedRim2_Mag,
  OverRangeRim1_Mag, OverRangeRim2_Mag;

// for Bob Synchronisation:
enum tDrive_SyncMode {Drive_SyncByCharronRing = 0, Drive_SyncByCenter_Mag, Drive_SyncByCenter_Cap,Drive_SyncByResonance};
extern tDrive_SyncMode Drive_SyncMode;
extern unsigned int PositionCounter_Drive, TDrive_Start, TDrive_Stop; 
extern bool 
  HaveSync, HalfSwing,
  SeenCenter_Cap, MissedCenter_Cap, 
  DidReSyncMyself, ForceReSync;

// for Rim detection_Magnetic:
enum tRimSyncMode {RimSyncByNone = 0, RimSyncByCenter_Mag, RimSyncByCenter_Cap, RimSyncByTBD};
extern tRimSyncMode RimSyncMode;
extern bool EnableDetectorRimPass_Mag;
 
// for Amplitude Control:
enum tAmplitudeControlMode {AmplitudeByNone = 0, AmplitudeByRim_Mag, AmplitudeByCenter_Cap, AmplitudeByTBD};
extern tAmplitudeControlMode AmplitudeControlMode;
extern unsigned int SetPoint_Amplitude_Ticks;  

// for Drive Strength
extern unsigned int
  Drive_MinimalCurrent, Drive_MaximalCurrent;
extern bool EnableDrive,
  ForceMaximalDriveCurrent, ForceMinimalDriveCurrent,
  UsingMaximalDriveCurrent, UsingMinimalDriveCurrent; 

// for Resonance Mode: 
extern unsigned long DDS_FrequencyWord;
extern unsigned int TResonanceDrive, Divider_T5, Divider_Final;
extern bool DoUpdate_DDS, DDS_FrequencyChanged;

// DDS_SCLK is on PORTA bit0, pin 22
#define DDS_SCLK_HIGH PORTA |=  0x01; 
#define DDS_SCLK_LOW  PORTA &= ~0x01; 

// DDS_SDATA is on PORTA bit1, pin 23
#define DDS_SDATA_HIGH PORTA |=  0x02;
#define DDS_SDATA_LOW  PORTA &= ~0x02;

// DDS_FFSYNC is on PORTA bit 2, pin 24
#define DDS_FSYNC_HIGH PORTA |=  0x04; 
#define DDS_FSYNC_LOW  PORTA &= ~0x04; 

// Forwards
void Init_BobControl (void);
void ReportSettings (void);     

// Output definitions

// Drive Pulse is on PORTG bit 0, pin 41 
// High is Rest, Low is Pulse
#define DRIVE_ON  PORTG &= ~0x01; // low = ON
#define DRIVE_OFF PORTG |= 0x01;  // high is OFF

// C_SHORT is on PORTL bit 4, pin 45
// High is Signal Shorted, Low is Signal Pass
#define CENTER_SHORT_SHORT PORTL |=  0x10; 
#define CENTER_SHORT_PASS  PORTL &= ~0x10; 

// C_GATE is on PORTL bit 0, pin 49
// High is Amplifier connected, Low is disconnect
#define CENTER_GATE_CONNECT    PORTL |=  0x01; 
#define CENTER_GATE_DISCONNECT PORTL &= ~0x01; 

// Center led is on PORTL bit 1, pin 48
#define CENTERLED_ON  PORTL |= 0x02; 
#define CENTERLED_OFF PORTL &= ~0x02; 

// Drive led is on PORTL bit 3, pin 46
#define DRIVELED_ON  PORTL |= 0x08; 
#define DRIVELED_OFF PORTL &= ~0x08; 

// Rim_1 led is on PORTL bit 5, pin 44
#define RIMLED_1_ON  PORTL |= 0x20; 
#define RIMLED_1_OFF PORTL &= ~0x20; 

// Rim_2 led is on PORTL bit 7, pin 42
#define RIMLED_2_ON  PORTL |= 0x80; 
#define RIMLED_2_OFF PORTL &= ~0x80; 

// HalfSwing_Led is on PORTC bit 1, pin 36
#define HALFSWINGLED_ON  PORTC |= 0x02; 
#define HALFSWINGLED_OFF PORTC &= ~0x02; 

// COMM led is on PORTC bit 3, pin 34
#define COMMLED_ON  PORTC |= 0x08; 
#define COMMLED_OFF PORTC &= ~0x08; 
#define COMMLED_TOGGLE PINC = 0x08; 

// SPARE1 led is on PORTC bit 5, pin 32
#define SPARELED_1_ON  PORTC |= 0x20; 
#define SPARELED_1_OFF PORTC &= ~0x20; 
#define SPARELED_1_TOGGLE PINC = 0x20; 

// SPARE2 led is on PORTC bit 7, pin 30
#define SPARELED_2_ON  PORTC |= 0x80; 
#define SPARELED_2_OFF PORTC &= ~0x80; 
#define SPARELED_2_TOGGLE PINC = 0x80; 

// Diagnostic pins Arduino MEGA, ADCH
#define USEDIAGPIN_A8  DDRK |=  0x01;
#define DIAGPIN_A8_H  PORTK |=  0x01; 
#define DIAGPIN_A8_L  PORTK &= ~0x01; 
#define DIAGPIN_A8_T   PINK =   0x01;

#define USEDIAGPIN_A9  DDRK |=  0x02;
#define DIAGPIN_A9_H  PORTK |=  0x02; 
#define DIAGPIN_A9_L  PORTK &= ~0x02; 
#define DIAGPIN_A9_T   PINK =   0x02;

#define USEDIAGPIN_A10 DDRK |=  0x04; 
#define DIAGPIN_A10_H PORTK |=  0x04; 
#define DIAGPIN_A10_L PORTK &= ~0x04; 
#define DIAGPIN_A10_T  PINK =   0x04;

#define USEDIAGPIN_A11 DDRK |=  0x08; 
#define DIAGPIN_A11_H PORTK |=  0x08; 
#define DIAGPIN_A11_L PORTK &= ~0x08; 
#define DIAGPIN_A11_T  PINK =   0x08;

#define USEDIAGPIN_A12 DDRK |=  0x10; 
#define DIAGPIN_A12_H PORTK |=  0x10; 
#define DIAGPIN_A12_L PORTK &= ~0x10; 
#define DIAGPIN_A12_T  PINK =   0x10;

#define USEDIAGPIN_A13 DDRK |=  0x20; 
#define DIAGPIN_A13_H PORTK |=  0x20; 
#define DIAGPIN_A13_L PORTK &= ~0x20; 
#define DIAGPIN_A13_T  PINK =   0x20;

#define USEDIAGPIN_A14 DDRK |=  0x40; 
#define DIAGPIN_A14_H PORTK |=  0x40; 
#define DIAGPIN_A14_L PORTK &= ~0x40; 
#define DIAGPIN_A14_T  PINK =   0x40;

#define USEDIAGPIN_A15 DDRK |=  0x80; 
#define DIAGPIN_A15_H PORTK |=  0x80; 
#define DIAGPIN_A15_L PORTK &= ~0x80; 
#define DIAGPIN_A15_T  PINK =   0x80;
#endif
