unit u_timestrings;

// Purpose: Some time related functions

{$mode objfpc}{$H+}

interface

uses SysUtils;

function DateTimeStamp: string;
function DateTimeStamp2: string;
function DateTimeStamp3: string;
function MyDate: string;
function MyTime_hm: string;
function MyTime2_hm: string;
function MyTime_hms: string;
function MyTime2_hmsms: string;
function ByteToTime (ByteVal: byte): string; // byte with 10 minute intervals to hh:mm
function HourPassed: boolean;
function MinutePassed: boolean;
function DayPassed: boolean;

implementation

function DayPassed: boolean;  // whole day passed
var Y, M, D: word;
const PrevDay: integer= -1;
begin
  DayPassed:= false;
  decodedate (now, Y, M, D);
  if Prevday = -1 then // prevent false result on first time use
  begin
    PrevDay:= D;
    exit;
  end;
  if D <> PrevDay then
  begin
    DayPassed:= true;
    PrevDay:= D;
  end;
end;

function HourPassed: boolean;  // whole hour passed
var h, m, s, ms: word;
const PrevHour: integer= -1;
begin
  HourPassed:= false;
  decodetime (now, h, m, s, ms);
  if PrevHour = -1 then  // prevent false result on first time use
  begin
    PrevHour:= h;
    exit;
  end;
  if h <> PrevHour then
  begin
    HourPassed:= true;
    PrevHour:= h;
  end;
end;

function MinutePassed: boolean;  // whole minute passed
var h, m, s, ms: word;
const PrevMinute: integer= -1;
begin
  MinutePassed:= false;
  decodetime (now, h, m, s, ms);
  if PrevMinute = -1 then // prevent false result on first time use
  begin
    PrevMinute:= m;
    exit;
  end;
  if m <> PrevMinute then
  begin
    MinutePassed:= true;
    PrevMinute:= m;
  end;
end;

function MyTime_hm: string;
var h, m, s, ms: word;
T1, T2: string;
begin
  decodetime (now, h, m, s, ms);
  str (h:2, T1); if h < 10 then T1[1]:= '0';
  str (m:2, T2); if m < 10 then T2[1]:= '0';
  MyTime_hm:= T1 + ':' + T2;
end;

// MyTime2 has no ':' so can be used as filename
function MyTime2_hm: string;
var h, m, s, ms: word;
T1, T2: string;
begin
  decodetime (now, h, m, s, ms);
  str (h:2, T1); if h < 10 then T1[1]:= '0';
  str (m:2, T2); if m < 10 then T2[1]:= '0';
  MyTime2_hm:= T1 + T2;
end;

// MyTime_hmsms has seconds and milliseconds
function MyTime_hmsms: string;
var h, m, s, ms: word;
T1, T2, T3, T4: string;
begin
  decodetime (now, h, m, s, ms);
  str (h:2, T1); if h < 10 then T1[1]:= '0';
  str (m:2, T2); if m < 10 then T2[1]:= '0';
  str (s:2, T3); if s < 10 then T3[1]:= '0';
  str (ms:3, T4);
  MyTime_hmsms:= T1 + ':' + T2 + ':' + T3 + '~' + T4;
end;

// MyTime_hmsms has seconds and milliseconds, but no ':'
function MyTime2_hmsms: string;
var h, m, s, ms: word;
T1, T2, T3, T4: string;
begin
  decodetime (now, h, m, s, ms);
  str (h:2, T1); if h < 10 then T1[1]:= '0';
  str (m:2, T2); if m < 10 then T2[1]:= '0';
  str (s:2, T3); if s < 10 then T3[1]:= '0';
  str (ms:3, T4);
  MyTime2_hmsms:= T1 + '-' + T2 + '-' + T3 + '~' + T4;
end;

function DateTimeStamp: string;
begin
  DateTimeStamp:= MyDate + '_' + MyTime_hmsms;
end;

// DateTimeStamp2 has no ':' so can be used as filename
function DateTimeStamp2: string;
begin
  DateTimeStamp2:= MyDate + '_' + MyTime2_hm;
end;

// DateTimeStamp3 has no ':' so can be used as filename
function DateTimeStamp3: string;
begin
  DateTimeStamp3:= MyDate + '_' + MyTime2_hmsms;
end;

function MyDate: string;
var Y, M, d: word;
T1, T2, T3: string;
begin
  decodedate(now, Y, m, d);
  Y:= Y mod 100;
  str (Y:2, T1); if Y < 10 then T1[1]:= '0';
  str (M:2, T2); if M < 10 then T2[1]:= '0';
  str (d:2, T3); if d < 10 then T3[1]:= '0';
  MyDate:= T1+ '-' + T2 + '-' + T3;
end;

function MyTime_hms: string;
var h, m, s, ms: word;
T1, T2, T3: string;
begin
  decodetime(now, h, m, s, ms);
  str (h:2, T1); if h < 10 then T1[1]:= '0';
  str (m:2, T2); if m < 10 then T2[1]:= '0';
  str (s:2, T3); if s < 10 then T3[1]:= '0';
  MyTime_hms:= T1 + ':' + T2 + ':' +T3;
end;

function ByteToTime (ByteVal: byte): string;
// ByteVal is in periods of 10 minutes
var h, m: integer;
T1, T2: string;
begin
  m:= (ByteVal mod 6) * 10;
  h:= ByteVal div 6;
  str (h:2, T1); if h < 10 then T1[1]:= '0';
  str (m:2, T2); if m < 10 then T2[1]:= '0';
  ByteToTime:= T1 + ':' + T2;
end;

begin
// no initialisation code
end.

