unit u_numstrings;

// Purpose: Some Numerical conversions

{$mode objfpc}{$H+}

interface

uses SysUtils;

function FIval (InpStr: string): longint;
function FRval (InpStr: string): real;
function BytesView (InpStr: string; Nch: integer): string;
function BytesViewHex (InpStr: string; Nch: integer): string;

implementation

function FIval (InpStr: string): longint;
var Temp: longint;
begin
  val (InpStr, Temp);
  FIval:= Temp;
end;

function FRval (InpStr: string): real;
var Temp: real;
begin
  val (InpStr, Temp);
  FRval:= Temp;
end;

function BytesView (InpStr: string; Nch: integer): string;
var N, A: integer; Temp, Total: string;
begin
  Total:= '';
  for N:= 1 to Nch do
  begin
    A:= byte (InpStr[N]);
    str(A:3, Temp);
    if Temp[2]= ' ' then Temp[2]:= '0';
    if Temp[1]= ' ' then Temp[1]:= '0';
    Total:= Total + Temp + ': ';
  end;
  BytesView:= Total;
end;

function BytesViewHex (InpStr: string; Nch: integer): string;
var N, A: integer; Temp, Total: string;
begin
  Total:= '';
  for N:= 1 to Nch do
  begin
    A:= byte (InpStr[N]);
    Temp:= format ('%2x',[A]);
    if Temp[1]= ' ' then Temp[1]:= '0';
    Total:= Total + Temp + ':';
  end;
  BytesViewhex:= Total;
end;

begin
// no initialisation code
end.

